% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cors.R
\name{get_cors}
\alias{get_cors}
\alias{put_cors}
\alias{delete_cors}
\title{CORS}
\usage{
get_cors(bucket, ...)

put_cors(bucket, ...)

delete_cors(bucket, ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
For \code{get_cors}: A list with cors configuration and rules. For \code{delete_cors}: \code{TRUE} if successful, \code{FALSE} otherwise.
}
\description{
Get/Put/Delete the cross origin resource sharing configuration information for a bucket.
}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html}{API Documentation: PUT cors}
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html}{API Documentation: GET cords}
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html}{API Documentation: DELETE cors}
}
