% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nec.R
\name{nec}
\alias{nec}
\title{Extracts the predicted NEC value as desired from an object of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.}
\usage{
nec(
  object,
  posterior = FALSE,
  xform = identity,
  prob_vals = c(0.5, 0.025, 0.975)
)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}} returned by \code{\link{bnec}}.}

\item{posterior}{A \code{\link[base]{logical}} value indicating if the full
posterior sample of calculated NEC values should be returned instead of
just the median and 95\% credible intervals.}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{prob_vals}{A vector indicating the probability values over which to
return the estimated NEC value. Defaults to 0.5 (median) and 0.025 and
0.975 (95 percent credible intervals).}
}
\value{
A vector containing the estimated NEC value, including upper and
lower 95\% credible interval bounds (or other interval as specified by
prob_vals).
}
\description{
Extracts the predicted NEC value as desired from an object of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.
}
\details{
The NEC is a parameter in a threshold model (for example,
see Fox 2010), and is a true measure
of No-effect-concentration (the minimum concentration above which an effect
is predicted to occur.
}
\examples{
library(bayesnec)
data(manec_example)
nec(manec_example)

}
\references{
Fox DR (2010). A Bayesian Approach for Determining the No Effect
Concentration and Hazardous Concentration in Ecotoxicology. Ecotoxicology
and Environmental Safety, 73(2), 123–131. doi: 10.1016/j.ecoenv.2009.09.012.
}
\seealso{
\code{\link{bnec}}
}
