% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{pca_supplementary_individuals}
\alias{pca_supplementary_individuals}
\title{Supplementary individual diagnostics}
\usage{
pca_supplementary_individuals(
  data,
  rotation,
  sdev,
  center = NULL,
  scale = NULL,
  total_weight = NA_real_
)
}
\arguments{
\item{data}{Matrix-like object whose rows correspond to supplementary
individuals and columns to the original variables.}

\item{rotation}{Rotation matrix from the PCA model (e.g. the \code{rotation}
element of a \code{\link{bigpca}} result).}

\item{sdev}{Numeric vector of component standard deviations associated with
\code{rotation}.}

\item{center}{Optional numeric vector giving the centring applied to each
variable when fitting the PCA. Defaults to zero centring.}

\item{scale}{Optional numeric vector describing the scaling applied to each
variable when fitting the PCA. When \code{NULL}, no scaling is applied.}

\item{total_weight}{Optional positive scalar passed to
\code{\link[=pca_individual_contributions]{pca_individual_contributions()}} when computing contributions. When left as
\code{NA} (the default), the resulting contributions for each component are
normalised to sum to one across supplementary individuals. Supplying a
value bypasses this normalisation and delegates the scaling to
\code{pca_individual_contributions()}.}
}
\value{
A list with elements \code{scores}, \code{contributions}, and \code{cos2}.
}
\description{
Compute principal component scores and quality metrics for
supplementary individuals (rows) projected into an existing PCA solution.
}
