% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frame.r
\name{data_frame}
\alias{data_frame}
\title{function to create a data_frame object}
\usage{
data_frame(
  data = stop("data must be supplied"),
  chunkSize = stop("chunkSize must be specified, a good number is 50000"),
  path = stop("path must be specified"),
  nCores = parallel::detectCores(),
  ...
)
}
\arguments{
\item{data}{data.frame object to be converted into a data_frame object}

\item{chunkSize}{number of rows to be used in each chunk}

\item{path}{character to folder where the object will be created}

\item{nCores}{the number of cores to use defaults to parallel::detectCores()}

\item{...}{not currently used.}
}
\description{
function to create a data_frame object. The data_frame object
             is an object that is held on disk. It is written to a folder
             \code{path} on disk where the data is written to in blocks or
             chunks. The data is written in binary format using a C++ function
             in purely numerical data and a mapping to the table is held in
             a ".meta_data" file in the folder. The table object accomodates
             numeric, factor, and character (converted to factor).
}
\details{
Creates a data_frame object
}
\examples{
irisA <- data_frame(iris[1:75,], 10, "irisA", nCores = 1)
irisA$append(iris[76:150,])
irisA$head()
irisA$tail(10)
irisA$delete(); rm(irisA)
}
