% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduced_mds.R
\name{reduced_mds}
\alias{reduced_mds}
\title{Reduced MDS}
\usage{
reduced_mds(x, l, r, n_cores)
}
\arguments{
\item{x}{A matrix with \eqn{n} individuals (rows) and \eqn{k} variables (columns).}

\item{l}{The size for which classical MDS can be computed efficiently
(using \code{cmdscale} function). It means that if \eqn{\bar{l}} is the limit
size for which classical MDS is applicable, then \code{l}\eqn{\leq \bar{l}}.}

\item{r}{Number of principal coordinates to be extracted.}

\item{n_cores}{Number of cores wanted to use to run the algorithm.}
}
\value{
Returns a list containing the following elements:
\describe{
\item{points}{A matrix that consists of \eqn{n} individuals (rows)
and \code{r} variables (columns) corresponding to the principal coordinates. Since
we are performing a dimensionality reduction, \code{r}\eqn{<<k}}
\item{eigen}{The first \code{r} largest eigenvalues:
\eqn{\lambda_i, i \in  \{1, \dots, r\} }, where each \eqn{\lambda_i} is obtained
from applying classical MDS to the first data subset.}
}
}
\description{
A data subset is selected and classical MDS is performed on it to obtain the
corresponding low dimensional configuration.Then the reaming points are projected
onto this initial configuration.
}
\details{
\emph{Gower's interpolation formula} is the central piece of this algorithm
since it allows to add a new set of points to an existing MDS configuration
so that the new one has the same coordinate system.

Given the matrix \code{x} with \eqn{n} points (rows) and
and \eqn{k} variables (columns), a first data subsets (based on a random sample)
of size \code{l} is taken and it is used to compute a MDS configuration.

The remaining part of \code{x} is divided into \eqn{p=({n}-}\code{l})\code{/l}
data subsets (randomly). For every data point, it is obtained a MDS
configuration by means of \emph{Gower's interpolation formula} and the first
MDS configuration obtained previously. Every MDS configuration is appended
to the existing one so that, at the end of the process, a global MDS
configuration for \code{x} is obtained.

#'This method is similar to \code{\link[=landmark_mds]{landmark_mds()}} and \code{\link[=interpolation_mds]{interpolation_mds()}}.
}
\examples{
set.seed(42)
x <- matrix(data = rnorm(4 * 10000), nrow = 10000) \%*\% diag(c(9, 4, 1, 1))
mds <- reduced_mds(x = x, l = 200, r = 2, n_cores = 1)
head(mds$points)
mds$eigen

}
\references{
Delicado P. and C. Pachón-García (2021). \emph{Multidimensional Scaling for Big Data}.
\url{https://arxiv.org/abs/2007.11919}.

Paradis E. (2018). \emph{Multidimensional Scaling With Very Large Datasets}. Journal of Computational and Graphical Statistics.

Borg, I. and P. Groenen (2005). \emph{Modern Multidimensional Scaling: Theory and Applications}. Springer.

Gower JC. (1968). \emph{Adding a point to vector diagrams in multivariate analysis}. Biometrika.
}
