% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domvar.r
\name{domvar}
\alias{domvar}
\title{Function to compute a dominant stand-level variable based on
a sample plot data.}
\usage{
domvar(
  data = data,
  var.int = var.int,
  var.sort = var.sort,
  plot.area = plot.area
)
}
\arguments{
\item{data}{data frame having the tree list of a sample plot.}

\item{var.int}{The column name of the data having the tree-level variable of
interest (e.g., height). Can be entered as the actual name, without the
need of using quotation marks.}

\item{var.sort}{The column name of the data having the tree-level variable
to be used as reference (e.g., diameter) for defining the sorting variable
of interest.}

\item{plot.area}{A numeric value of the plot area in m\eqn{^{2}}{^2}.}
}
\value{
The main output is the calculated dominant stand-variable for the
given sample plot. The unit of the computed variable is the same as the
one used as variable of interest.
}
\description{
Computes the so-called dominant stand-level variable, corresponding
to the average of a tree-level variable for the 100 largest
sorting-tree-level diameter trees in 1-ha.
}
\details{
The original function was written by Dr Oscar García for computing
top height, and the corresponding reference is provided. Nevertheless,
several changes were applied, thus the current function provide a broader
application. Regardless, the function aims to calculate a "dominant"
stand-level variable by taking into account the plot area.
Thus, requires having a dataframe having both the variable
of interest (e.g., height) and the sorting variable used for the
computation (e.g., diameter) for all trees in a sample plot, as well as,
the plot area.
}
\examples{

##Creates a fake dataframe
set.seed(45)
x <- round(rnorm(20,mean=45,sd=10),1); y=round(1.3+35*(1-exp(-.07*x)),1)
df<-data.frame(dap=x,atot=y)
head(df)
datana::descstat(df)
##Using the domvar function
domvar(data=df,var.int=atot,var.sort=dap,plot.area=500)
}
\references{
\itemize{
\item García O, Batho A. 2005. Top height estimation in lodgepole pine
sample plots. Western Journal of Applied forestry 20(1):64-68.
}
}
\author{
Christian Salas-Eljatib.
}
