% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-spatimepsp.r
\docType{data}
\name{spatimepsp}
\alias{spatimepsp}
\title{Temporal tree locations within a sample plot in the Vienna woods}
\format{
Contains cartesian position of trees, and covariates,
in a sample plot, as follows:
\describe{
\item{plot}{Plot number.}
\item{tree}{Tree number.}
\item{species}{Species code as follows:
PCAB=\emph{Picea abies}, LADC=\emph{Larix decidua}, PNSY=\emph{Pinus sylvestris},
FASY=\emph{Fagus Sylvatica}, QCPE=\emph{Quercus petraea}, BTPE=\emph{Betula pendula}.}
\item{x.coord}{Cartesian position in the X-axis, in m.}
\item{y.coord}{Cartesian position in the Y-axis, in m.}
\item{year}{Measurement year.}
\item{dbh}{diameter at breast-height, in cm.}
}
}
\source{
Data were retrieved from the paper cited below, where several details
might be worth reading.
}
\usage{
data(spatimepsp)
}
\description{
The Austrian Research Center for Forests established a spacing experiment
with Norway spruce (\emph{Picea abies}) in the Vienna Woods. In the ``Hauersteig''
experiment, several tree-level variables were measured within four sample
plots over time.
}
\examples{
data(spatimepsp)
head(spatimepsp)
df<-spatimepsp
lattice::xyplot(y.coord~x.coord|as.factor(year),
data=df,as.table=TRUE)
}
\references{
\itemize{
\item Kindermann G. Kristofel F, Neumann M, Rossler G, Ledermann T &
Schueler. 2018. 109 years of forest growth measurements from
individual Norway spruce trees. Sci. Data 5:180077
\doi{10.1038/sdata.2018.77}
}
}
\keyword{datasets}
