% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-sints-exp-golomb.R
\name{bs_write_sint_exp_golomb}
\alias{bs_write_sint_exp_golomb}
\alias{bs_read_sint_exp_golomb}
\title{Read/Write Exponential-Golomb encoded signed integers}
\usage{
bs_write_sint_exp_golomb(bs, x)

bs_read_sint_exp_golomb(bs, n = 1L)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{x}{integer vector to write}

\item{n}{number of encoded integers to read}
}
\value{
Reading returns a vector of integers. Writing returns
   the bitstream invisibly.
}
\description{
Read/Write Exponential-Golomb encoded signed integers
}
\examples{
bs  <- bs_open(raw(), 'w')
bs_write_sint_exp_golomb(bs, c(0, 4, -21))
raw_vec <- bs_close(bs)
raw_vec


bs  <- bs_open(raw_vec, 'r')
bs_read_sint_exp_golomb(bs, 3)
bs_close(bs)
}
