% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-ints.R
\name{bs_write_uint}
\alias{bs_write_uint}
\alias{bs_read_uint}
\title{Read/Write unsigned integers}
\usage{
bs_write_uint(bs, x, nbits)

bs_read_uint(bs, nbits, n = 1L)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{x}{integer vector to write}

\item{nbits}{the number of bits used for each integer}

\item{n}{number of integers to read}
}
\value{
Reading returns a vector of non-negative integers. Writing returns
   the bitstream invisibly.
}
\description{
Read/Write unsigned integers
}
\examples{
bs  <- bs_open(raw(), 'w')
bs_write_uint(bs, c(0, 4, 21), nbits = 5)
bs_align(bs, 8)
raw_vec <- bs_close(bs)
raw_vec

bs  <- bs_open(raw_vec, 'r')
bs_read_uint(bs, n = 3, nbits = 5)
bs_close(bs)
}
