% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-uints-exp-golomb.R
\name{bs_write_uint_exp_golomb}
\alias{bs_write_uint_exp_golomb}
\alias{bs_read_uint_exp_golomb}
\title{Read/Write Exponential-Golomb encoded non-negative integers}
\usage{
bs_write_uint_exp_golomb(bs, x)

bs_read_uint_exp_golomb(bs, n = 1L)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{x}{integer vector to write}

\item{n}{number of encoded integers to read}
}
\value{
Reading returns a vector of non-negative integers. Writing returns
   the bitstream invisibly.
}
\description{
Read/Write Exponential-Golomb encoded non-negative integers
}
\examples{
bs  <- bs_open(raw(), 'w')
bs_write_uint_exp_golomb(bs, c(0, 4, 21))
bs_align(bs, 8)
raw_vec <- bs_close(bs)
raw_vec


bs  <- bs_open(raw_vec, 'r')
bs_read_uint_exp_golomb(bs, 3)
bs_close(bs)
}
