% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflation.R
\name{inflation_adjust}
\alias{inflation_adjust}
\title{Convert the Value of a US Dollar to a Given month on or after 1947.}
\usage{
inflation_adjust(base_date = NA, ...)
}
\arguments{
\item{base_date}{= A string argument to represent the base month that you would like dollar values converted to. 
For example, if you want to see the value of a Jan. 2015 dollar in Jan. 2023, you would select "2015-01-01" as a base date and find Jan 2023 in the table.}

\item{...}{additional arguments}
}
\value{
A tibble from the BLS API.
}
\description{
Returns a data frame that uses data from the Consumer Price Index (All Goods) to convert the value of a US Dollar [$1.00 USD] over time.
}
\examples{
\dontrun{
## Get historical USD values based on a dollar from Jan 2015.
values <- inflation_adjust(base_year = "2015-01-01")
}

}
\keyword{api}
\keyword{bls}
\keyword{cpi}
\keyword{economics}
\keyword{inflation}
\keyword{unemployment}
