% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jeffreys.R
\name{Jeffreys.GBN}
\alias{Jeffreys.GBN}
\title{Jeffreys Divergence for \code{GBN}}
\usage{
\method{Jeffreys}{GBN}(x, where, entry, delta, ...)
}
\arguments{
\item{x}{object of class \code{GBN}.}

\item{where}{character string: either \code{mean} or \code{covariance} for variations of the mean vector and covariance matrix respectively.}

\item{entry}{if \code{where == "mean"}, \code{entry} is the index of the entry of the mean vector to vary. If \code{where == "covariance"}, entry is a vector of length 2 indicating the entry of the covariance matrix to vary.}

\item{delta}{numeric vector, including the variation parameters that act additively.}

\item{...}{additional arguments for compatibility.}
}
\value{
A dataframe including in the first column the variations performed and in the second column the corresponding Jeffreys divergences.
}
\description{
\code{Jeffreys.GBN} returns the Jeffreys divergence between an object of class \code{GBN}  and its update after a standard parameter variation.
}
\details{
Computation of the Jeffreys divergence between a Bayesian network and the additively perturbed Bayesian network, where the perturbation is either to the mean vector or to the covariance matrix.
}
\examples{
Jeffreys(synthetic_gbn,"mean",2,seq(-1,1,0.1))
Jeffreys(synthetic_gbn,"covariance",c(3,3),seq(-1,1,0.1))

}
\references{
Goergen, C., & Leonelli, M. (2018). Model-preserving sensitivity analysis for families of Gaussian distributions. arXiv preprint arXiv:1809.10794.
}
\seealso{
\code{\link{KL.GBN}}\code{\link{KL.CI}}, \code{\link{Fro.CI}}, \code{\link{Fro.GBN}}, \code{\link{Jeffreys.CI}}
}
