% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_values.R
\name{.Get_reference_value}
\alias{.Get_reference_value}
\title{Get reference for a given combination of model and percentile/z-score}
\usage{
.Get_reference_value(
  metric,
  sex,
  level,
  age,
  percentile = NULL,
  z_score = NULL,
  verbose = FALSE,
  digits = 0
)
}
\arguments{
\item{metric}{character, body composition metric}

\item{sex}{character, "Female" or "Male"}

\item{level}{character, used vertebral level}

\item{age}{integer, age}

\item{percentile}{numeric, percentile to return value for. If both percentile and z_score are given, only percentile is evaluated}

\item{z_score}{numeric, z score to return value for. If both percentile and z_score are given, only percentile is evaluated}

\item{verbose}{logical, should messages be discplayed}

\item{digits}{integer, digits to round reference value}
}
\value{
numeric, corresponding percentile
}
\description{
For a given constellation of metric, sex, vertebral level, and age returns the corresponding measurement for a given percentile/z-score
}
\author{
J. Peter Marquardt
}
