% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category-helpers.R
\name{boilerplate_template}
\alias{boilerplate_template}
\title{Access Template Content}
\usage{
boilerplate_template(unified_db, name = NULL)
}
\arguments{
\item{unified_db}{List. The unified boilerplate database containing template content}

\item{name}{Character. Optional specific template to retrieve by name}
}
\value{
List or character. The requested template database or specific template.
If name is NULL, returns the entire template database. If name is specified,
returns the template with that name.
}
\description{
This function extracts and returns the template portion of a unified database,
optionally retrieving a specific template by name.
}
\details{
Access Templates from Unified Database
}
\examples{
# Create a temporary directory and initialise database
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_template_example", "data")

# Initialise with default template content
boilerplate_init(
  categories = "template",
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import all databases
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Get all templates
template_db <- boilerplate_template(unified_db)
names(template_db)

# Get a specific template (if it exists)
if ("template" \%in\% names(unified_db) && length(unified_db$template) > 0) {
  template_names <- names(unified_db$template)
  if (length(template_names) > 0) {
    first_template <- boilerplate_template(unified_db, template_names[1])
  }
}

# Clean up
unlink(file.path(temp_dir, "boilerplate_template_example"), recursive = TRUE)

}
