% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliography-support.R
\name{boilerplate_update_bibliography}
\alias{boilerplate_update_bibliography}
\title{Update Bibliography from Remote Source}
\usage{
boilerplate_update_bibliography(
  db,
  cache_dir = NULL,
  force = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{db}{Database object containing bibliography information}

\item{cache_dir}{Directory to cache the bibliography file.
Default uses tools::R_user_dir("boilerplate", "cache")}

\item{force}{Logical. Force re-download even if cached file exists}

\item{quiet}{Logical. Suppress messages}
}
\value{
Path to the local bibliography file, or NULL if no bibliography specified
}
\description{
Downloads and caches a bibliography file from a remote URL specified in the database.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and import
boilerplate_init(data_path = temp_dir, create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Update bibliography
bib_file <- boilerplate_update_bibliography(db)

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
