% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas.R
\name{Atlas Helpers}
\alias{Atlas Helpers}
\alias{guess_atlas}
\alias{as_atlas}
\alias{create_atlas}
\title{Atlas helper functions}
\usage{
guess_atlas(x)

as_atlas(object)

create_atlas(regions, coords, lobes, hemis, other = NULL)
}
\arguments{
\item{x, object}{An object to test or convert to an atlas data.table}

\item{regions}{Character vector of region names}

\item{coords}{Numeric matrix of spatial coordinates; must have 3 columns}

\item{lobes}{Character or factor vector of lobe membership}

\item{hemis}{Character or factor vector of hemisphere membership. There
should probably not be more than 3 unique elements (for left, right, and
bi-hemispheric regions)}

\item{other}{A \emph{named list} of vectors with other data. The names of the
list will become column names in the return object.}
}
\value{
\code{guess_atlas} - Character string; either the matched atlas or
  \code{NA}

\code{as_atlas} and \code{create_atlas} return a \code{data.table}
  that conforms to other atlases in the package, or exits with an error.
}
\description{
\code{guess_atlas} tries to determine which atlas is being used based on the
data; i.e., the number of vertices/regions.

\code{as_atlas} and \code{create_atlas} converts/coerces an object to a
a \code{data.table}, or creates one, that is compatible with
\code{brainGraph}.
}
\section{Guessing the atlas from an object}{

There are several valid inputs to \code{guess_atlas}:
\describe{
  \item{data.table}{The atlas will be guessed based on the number of columns
    (subtracting by 1 if a \dQuote{Study ID} column is present). This is the
    same behavior as for \code{data.frame} objects, as well.}
  \item{igraph}{The vertex count}
  \item{brainGraph}{If there is a \code{atlas} graph-level attribute, it will
    return that. Otherwise, the vertex count.}
  \item{matrix,array}{The number of rows, which should equal the number of
    columns if the input is a connectivity matrix.}
}

Note that this will only work properly for atlases that are currently in the
package. If you are using a custom atlas and you receive errors, please open
an issue on \emph{GitHub}.
}

\section{Coercing to an atlas}{

There are several things \code{as_atlas} tries to do to make it work without
error:
\itemize{
  \item Coerce the object to \code{data.table}
  \item Add a column of integers named \code{index}
  \item Change columns named \code{'x'}, \code{'y'}, or \code{'z'} to have
    \code{.mni} at the end
  \item Convert the \code{lobe} and \code{hemi} columns to be \emph{factors}
}
}

\examples{
my_atlas <- data.frame(name=paste('Region', 1:10), x.mni=rnorm(10),
  y.mni=rnorm(10), z.mni=rnorm(10),
  lobe=rep(c('Frontal', 'Parietal', 'Temporal', 'Occipital', 'Limbic'), 2),
  hemi=c(rep('L', 5), rep('R', 5)))
my_atlas2 <- as_atlas(my_atlas)
str(my_atlas)
str(my_atlas2)
regions <- paste('Region', 1:10)
xyz <- matrix(rnorm(30), nrow=10, ncol=3)
lobe <- rep(c('Frontal', 'Parietal', 'Temporal', 'Occipital', 'Limbic'), 2)
hemi <- c(rep('L', 5), rep('R', 5))
other <- list(network=rep(c('Default mode', 'Task positive'), 5))
my_atlas <- create_atlas(regions, xyz, lobe, hemi, other)
str(my_atlas)
}
