% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemical_details}
\alias{get_chemical_details}
\title{Retrieve chemical details from DTXSID of DTXCID}
\usage{
get_chemical_details(
  DTXSID = NULL,
  DTXCID = NULL,
  Projection = "chemicaldetailstandard",
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{DTXCID}{The chemical identifier DTXCID}

\item{Projection}{The format and chemical detail data returned. Allowed
values are 'chemicaldetailall', 'chemicaldetailstandard',
'chemicalidentifier', 'chemicalstructure', 'ntatoolkit',
'ccdchemicaldetails'. If left empty or there is a mismatch, the default
format will be 'chemicaldetailstandard'.}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be
given.}
}
\value{
A data.table containing chemical information for the chemical with
DTXSID matching the input parameter.
}
\description{
Retrieve chemical details from DTXSID of DTXCID
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical details for BPA
bpa <- get_chemical_details(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
