% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs-batch.R
\name{get_skin_eye_hazard_batch}
\alias{get_skin_eye_hazard_batch}
\title{Get skin and eye hazard batch}
\usage{
get_skin_eye_hazard_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSIDs}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames containing skin and eye hazard data for
each input DTXSID.
}
\description{
Get skin and eye hazard batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull skin eye hazard data for multiples chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
dtxsid_skin_eye_hazard <- get_skin_eye_hazard_batch(DTXSID = dtxsid)
\dontshow{\}) # examplesIf}
}
