% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_clean.R
\name{clearing_fa}
\alias{clearing_fa}
\title{Function to quickly organize and clear psych factor loadings}
\usage{
clearing_fa(
  psych_fa,
  cutoff = 0.4,
  dbl_dist = 0.2,
  key_file = NULL,
  cleaned = TRUE
)
}
\arguments{
\item{psych_fa}{Output from the psych package, can be either fa or principal with at least two dimensions}

\item{cutoff}{Desired cutoff below which loadings are omitted defaults to .40}

\item{dbl_dist}{Desired distance between highest and second highest loading for an item to remove double loadings, defaults to .20}

\item{key_file}{Optional: Either a .csv or .xlsx file with at least two columns:
1 labeled item containing the item labels as in the data frame,
2 a column labeled wording containing the item wording.}

\item{cleaned}{If true (default), only the cleaned solution with a message for descriptive stats are returned.
If false the function returns a list of data frames one cleaned and one showing all in-between steps}
}
\value{
clean This column contains the assignment after removing NAs and double loadings

dir This column contains the direction (positive or negative) of the highest loading.
}
\description{
Function to quickly organize and clear psych factor loadings
}
\examples{
library(psych)
fa_solution <- fa(example[c(paste0("help", 1:6, "m"), c(paste0("voice", 1:5, "m")))], nfactors = 2)
clearing_fa(fa_solution)
}
