% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{dpkb}
\alias{dpkb}
\title{Density Function for PKB distribution}
\usage{
dpkb(y, mu, rho, log = FALSE)
}
\arguments{
\item{y}{A matrix or data frame where each row represents a data point on the unit hypersphere.}

\item{mu}{A vector or matrix representing the mean direction parameter(s).
If a vector, it must be normalized (unit length) and is applied to all data points.
If a matrix, it must have the same number of rows as \code{y}, and each row must be normalized.}

\item{rho}{A scalar or a vector representing the concentration parameter.
If a vector, its length must match the number of rows in \code{y}.
Each \code{rho[i]} is used to evaluate the density for \code{y[i, ]}.
Must be between 0 (inclusive) and 1 (exclusive).}

\item{log}{Logical; if TRUE, the log-density is returned. Default is FALSE.}
}
\value{
A vector of density values (or log-density if log = TRUE) for each row in y.
}
\description{
Calculates the density of the PKB distribution for given data points.
}
\details{
This function calculates the density of the PKB distribution for each data point in y, given the
parameters mu and rho.
}
\examples{
y <- matrix(c(1, 0, 0, 0, 0, 1), ncol = 3, byrow = TRUE)
mu <- c(1, 0, 0)
rho <- 0.5
dpkb(y, mu, rho)
}
