% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment.R
\name{AggregationScore}
\alias{AggregationScore}
\title{Calculate the aggregation score for specific clusters}
\usage{
AggregationScore(seu, reduction.name = "cofast", random.seed = 1)
}
\arguments{
\item{seu}{a SeuratObject with reductions not \code{NULL}.}

\item{reduction.name}{an character, specify the reduction name for calculating the aggregation score.}

\item{random.seed}{a positive integer, specify the random seed for reproducibility.}
}
\value{
return a data.frame with two columns: the first column is the number of spots in each category (cluster/cell type); the second column is the corresponding aggregation score.
}
\description{
Calculate the adjacency matrix given a spatial coordinate matrix with 2-dimension or 3-dimension or more.
}
\examples{
library(Seurat)
data(CosMx_subset)
CosMx_subset <- Addcoord2embed(CosMx_subset, coord.name = c("x", "y"))
Idents(CosMx_subset) <- 'cell_type'
\donttest{
dat.sp.score <- AggregationScore(CosMx_subset, reduction.name = 'Spatial')
print(dat.sp.score)
}

}
\references{
None
}
\seealso{
None
}
