% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/law.R
\name{cong_law}
\alias{cong_law}
\title{Request Law Information}
\usage{
cong_law(
  congress = 118,
  type = NULL,
  number = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{type}{Type of law. Must be \code{'pub'} or \code{'priv'}.}

\item{number}{Law number. Numeric.}

\item{from_date}{Start date for search, e.g. \code{'2022-04-01'}. Optional.}

\item{to_date}{End date for search, e.g. \code{'2022-04-30'}. Optional.}

\item{limit}{Number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{Number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for clean = FALSE. One of \code{'json'} or \code{'xml'}.}

\item{clean}{Should output be returned as a tibble (\code{TRUE}) or requested format (\code{FALSE}). Default is \code{TRUE}.}
}
\value{
A tibble or raw HTTP response if clean = FALSE.
}
\description{
Request Law Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_law(congress = 118)

cong_law(congress = 118, type = 'pub')

cong_law(congress = 118, type = 'pub', number = 108)
\dontshow{\}) # examplesIf}
}
