% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cophe_hyp_predict.R
\name{cophe.hyp.predict}
\alias{cophe.hyp.predict}
\title{Predict cophescan hypothesis for tested associations}
\usage{
cophe.hyp.predict(
  cophe.res,
  grouping.vars = c("querysnp", "querytrait"),
  Hc.cutoff = 0.6,
  Hn.cutoff = 0.2
)
}
\arguments{
\item{cophe.res}{results obtained from \code{cophe.single}, \code{cophe.susie} or \code{cophe.multitrait} or data.frame with the following columns: PP.Hn, PP.Hc, PP.Ha, querysnp, querytrait}

\item{grouping.vars}{This is important for results from \code{cophe.susie} where there are multiple signals. These will be collapsed into one call. If you want to return all signals set this to a single variable eg: grouping.vars = c('querysnp')}

\item{Hc.cutoff}{threshold for PP.Hc above which the associations are called Hc}

\item{Hn.cutoff}{threshold for PP.Hn above which the associations are called Hn}
}
\value{
returns dataframe with posterior probabilties of Hn, Hc and Ha with the predicted hypothesis based on the provided cut.offs.
}
\description{
Predict cophescan hypothesis for tested associations
}
\seealso{
\code{\link{cophe.single}}, \code{\link{cophe.susie}}, \code{\link{cophe.multitrait}}, , \code{\link{multitrait.simplify}}
}
