/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.ext.problems.objectives;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.ext.problems.objectives.evaluations.WeightedIndexEvaluation;

public class WeightedIndex<SolutionType extends Solution, DataType>
implements Objective<SolutionType, DataType> {
    private final Map<Objective<? super SolutionType, ? super DataType>, Double> weights = new LinkedHashMap<Objective<? super SolutionType, ? super DataType>, Double>();

    public void addObjective(Objective<? super SolutionType, ? super DataType> objective, double weight) {
        if (!(weight > 0.0)) {
            throw new IllegalArgumentException("Error in weighted index: each objective's weight should be strictly positive.");
        }
        this.weights.put(objective, weight);
    }

    public boolean removeObjective(Objective<? super SolutionType, ? super DataType> objective) {
        if (this.weights.containsKey(objective)) {
            this.weights.remove(objective);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMinimizing() {
        return false;
    }

    @Override
    public WeightedIndexEvaluation evaluate(SolutionType solution, DataType data) {
        WeightedIndexEvaluation eval = new WeightedIndexEvaluation();
        this.weights.keySet().forEach(obj -> {
            Evaluation objEval = obj.evaluate(solution, data);
            double w = this.weights.get(obj);
            if (obj.isMinimizing()) {
                w = -w;
            }
            eval.addEvaluation((Objective)obj, objEval, w);
        });
        return eval;
    }

    @Override
    public <ActualSolutionType extends SolutionType> WeightedIndexEvaluation evaluate(Move<? super ActualSolutionType> move, ActualSolutionType curSolution, Evaluation curEvaluation, DataType data) {
        WeightedIndexEvaluation curEval = (WeightedIndexEvaluation)curEvaluation;
        WeightedIndexEvaluation newEval = new WeightedIndexEvaluation();
        this.weights.keySet().forEach(obj -> {
            Evaluation objCurEval = curEval.getEvaluation((Objective)obj);
            Evaluation objNewEval = obj.evaluate(move, curSolution, objCurEval, data);
            double w = this.weights.get(obj);
            if (obj.isMinimizing()) {
                w = -w;
            }
            newEval.addEvaluation((Objective)obj, objNewEval, w);
        });
        return newEval;
    }

    public String toString() {
        return this.weights.keySet().stream().map(obj -> "(" + obj + ", " + this.weights.get(obj) + ")").collect(Collectors.joining(", ", "Weighted index: ", ""));
    }
}

