% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covastat.R
\docType{class}
\name{covastat-class}
\alias{covastat-class}
\alias{covastat}
\alias{show,covastat-method}
\alias{covastat-method}
\title{Class "covastat"}
\usage{
covastat(matdata, pardata1, pardata2, stpairs, typetest = "sym")

\S4method{show}{covastat}(object)
}
\arguments{
\item{matdata}{STFDF/STSDF or \code{data.frame}, which contains the
coordinates of the spatial points, the identification code of the spatial
points, the indentification code of the temporal points and the values of
the variable, typically output from \code{read.STdata}}

\item{pardata1}{integer, it represents the column in which the spatial ID is
stored (if the spatio-temporal data set is given as data.frame) or the number of
variables in the STFDF/STSDF (if the data are given as a STFDF/STSDF)}

\item{pardata2}{integer, it represents the column in which the values of the
variable are stored (if the spatio-temporal data set is given as data.frame) or
the slot in which the values of the variable of interest are stored
(if the data are given as a STFDF/STSDF). Note that for STFDF/STSDF the
argument is set, by default, equal to 1 if the number of variables is equal to 1}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{character, set \code{typetest = "sym"} for symmetry test
(default choice), \code{typetest = "sep"} for separability test, \code{typetest = "tnSep"}
for type of non separability test}

\item{object}{object of class \code{covastat} for method \code{show}}
}
\description{
A class for the sample spatio-temporal covariances for the specified spatial
and temporal lags, given in \code{stpairs} (object of class \code{couples}),
for symmetry, separability and type of non separability tests.
Depending on the type of test, the empirical variance, the sample spatial
and temporal marginal covariances are also computed
}
\details{
{
\itemize{
\item A message appears on the user's console if the \code{G} vector
contains spatio-temporal negative covariances. The message returns the negative
value/values and it will help to identify the spatial and the temporal lags
involved
\item If \code{typetest = "sym"} (symmetry test) \code{cova.h}, \code{cova.u},
\code{f.G} and \code{B} are not available
}
}
}
\section{Slots}{

\describe{
\item{\code{G}}{matrix, containing the spatio-temporal covariances for the specified
lags. For all tests, except for the symmetry test (\code{typetest = "sym"}), the
sample variance and the sample spatial and temporal marginal covariances are
also computed and stored in \code{G}}

\item{\code{cova.h}}{matrix, containing the sample spatial marginal covariances
for the specified lags}

\item{\code{cova.u}}{matrix, containing the sample temporal marginal covariances
for the specified lags}

\item{\code{f.G}}{array, containing the computation of specific functions of the
elements of \code{G}, see references}

\item{\code{B}}{matrix, containing the computation of the derivatives of each element
of \code{f.G} with respect to each element of \code{G}}

\item{\code{A}}{contrast matrix}

\item{\code{typetest}}{character, contains the code of the test to be performed}
}}

\note{
\itemize{
\item A stop occurs if the number of spatial points fixed in \code{stpairs}
(object of class \code{couples}) is less than 2
\item A stop occurs if more than 75\\% of consecutive data are missing in the time
series, since a large number of missing values do not guarantee the reliability
of the tests
}
}
\examples{
# --start define the STFDF rr_13-- #
library(sp)
library(spacetime)
#library(gstat)
data(air)
ls()
if (!exists("rural")) rural = STFDF(stations, dates, data.frame(PM10 =
as.vector(air)))
rr = rural[,"2005::2010"]
unsel = which(apply(as(rr, "xts"), 2, function(x) all(is.na(x))))
r5to10 = rr[-unsel,]
rr_13 <- r5to10[c("DEHE046","DESN049","DETH026","DENW063","DETH061","DEBY047",
"DENW065","DEUB029","DENW068","DENI019","DEHE051","DERP016","DENI051"),
"2005::2006"]
# --end define the STFDF rr_13-- #

sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = "sym", typecode = character())

covast.sym <- covastat(matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym, typetest = "sym")

### method for covastat
#1. show
covast.sym

}
\references{
Cappello, C., De Iaco, S., Posa, D., 2018, Testing the type of
non-separability and some classes of space-time covariance function models.
Stochastic Environmental Research and Risk Assessment,
\bold{32} 17--35

Cappello, C., De Iaco, S., Posa, D., 2020, {covatest}: An {R} Package for
Selecting a Class of Space-Time Covariance Functions.
Journal of Statistical Software, \bold{94(1)} 1--42.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.
}
\seealso{
\linkS4class{couples}

\code{\link{read.STdata}}
}
