% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRASSMAT.R
\name{crassmat}
\alias{crassmat}
\title{Conditional Random Sampling Sparse Matrices}
\usage{
crassmat(data, sample_thres, conditional)
}
\arguments{
\item{data}{a matrix (supports sparsity, missing values, and complete matrices)}

\item{sample_thres}{a non-negative decimal specifying the percentage of observed values sampled out}

\item{conditional}{a non-negative integer specifying the number of observed values to remain per row}
}
\value{
Returns a matrix object with observed values removed according to the specified \code{sample_thres} and \code{conditional}.
}
\description{
Conducts conditional random sampling on observed values in sparse matrices. Useful for training and test set splitting sparse matrices prior to model fitting in cross-validation procedures and estimating the predictive accuracy of data imputation methods, such as matrix factorization or singular value decomposition (SVD). Although designed for applications with sparse matrices, CRASSMAT can also be applied to complete matrices, as well as to those containing missing values.
}
\details{
Takes a matrix A\emph{ij} and samples out a single \emph{jth} value on the condition that the number of \emph{jth} values within the \emph{ith} observation is greater than the specified conditional (minimum number of values to remain per \emph{ith} observation). This process repeats itself until the specified sampling threshold is met.
}
\examples{
## test set
A_test <- A

## training set
A_train <- crassmat(data = A,            # matrix
                    sample_thres = 0.20, # remove 20\% of observed values
                    conditional = 1)     # keep > 1 observed values per row
}
\references{
Kunz, N. (2019). \emph{Unsupervised Learning for Submarket Modeling: A Proxy for Neighborhood Change} (Master's Thesis). Columbia University, New York, NY.
}
\author{
Nick Kunz <\email{nick.kunz@columbia.edu}>
}
\keyword{conditional}
\keyword{imputation}
\keyword{matrices}
\keyword{matrix}
\keyword{random}
\keyword{sampling}
\keyword{sparse}
