% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{cvfitplot}
\alias{cvfitplot}
\title{Plot output of cvfit to facilitate comparison}
\usage{
cvfitplot(cvKeep, xlock = c("mean", "median"), cvRF = NULL, cvSP = NULL)
}
\arguments{
\item{cvKeep}{The output of \code{\link{cvfit}}.}

\item{xlock}{Focus horizontal axis on \code{mean} or \code{median}, The latter provides a narrower range, facilitating comparison when there are outliers.}

\item{cvRF}{Include cross-validation results from random forecast non-parametric curves. Obtain these from \code{\link{cvnpcurve}} with \code{type="rforest"}. Use \code{NULL} to ignore.}

\item{cvSP}{Include cross-validation results from spline regression non-parametric curves. Obtain these from \code{\link{cvnpcurve}} with \code{type="spline"}. Use \code{NULL} to ignore.}
}
\value{
No returned value. Produces a summary plot of cross-validated errors.
}
\description{
Plot summarised error of different curves specification from \code{\link{cvfit}}.
Assuming normal errors, plot the mean cross-validated error and the 95% interval around it for each curve and its best selection of variables.
}
\examples{
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1:3,drop=FALSE]
  cvKeep <- cvfit(x,rate,folds=5,alltype=c("logistic","arctan"),parallel=TRUE)
  cvfitplot(cvKeep)
  # Add results from non-parameteric curves
  cvRF <- cvnpcurve(x,rate,cvKeep$cvIndex)
  cvSP <- cvnpcurve(x,rate,cvKeep$cvIndex,type="spline")
  cvfitplot(cvKeep,cvRF=cvRF,cvSP=cvSP)
}

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{cvfit}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
