% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_nested_subsystems}
\alias{cvd_area_nested_subsystems}
\title{Retrieve nested sub-systems for an NHS area}
\usage{
cvd_area_nested_subsystems(area_id)
}
\arguments{
\item{area_id}{Integer (required). The AreaID for which to retrieve nested sub-system data. Use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid IDs.}
}
\value{
A named list of tibbles, where each element (\code{level_1}, \code{level_2}, etc.) contains details for the specified area and each subsequent child level.
If no data is found, returns a tibble describing the error.

Each tibble contains the following columns:
\describe{
\item{AreaCode}{Character. Unique code for the NHS area (e.g., "U11103").}
\item{AreaID}{Integer. Unique identifier for the NHS area.}
\item{AreaName}{Character. Name of the NHS area (e.g., "Yeovil PCN").}
\item{AreaOdsCode}{Character. ODS (Organisation Data Service) code for the area, if available. Often blank.}
\item{ParentAreaID}{Integer. ID of the parent NHS area or organisation (e.g., ICB or region).}
\item{SystemLevelID}{Integer. Identifier for the system level (e.g., 4 = PCN).}
\item{SystemLevelName}{Character. Name of the system level (e.g., "PCN").}
}
}
\description{
Returns a hierarchical (nested) structure of the specified NHS area and all of its descendent (child) areas from the CVDPREVENT API. This function is useful for exploring the parent-child relationships within NHS geographies, such as seeing a PCN and all of its practices, or an ICB with all subordinate structures.

The output is a list of tibbles, one for each "level" in the heirarchy, named as \code{level_1}, \code{level_2}, etc. Each tibble contains the details for the areas at that level.
}
\details{
This function is helpful for visualising or programmatically traversing the full nested structure beneath a given NHS area. For example, given an ICB, you can see all PCNs, then all practices beneath those PCNs, and so on.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2F\%3Carea_id\%3E\%2FnestedSubSystems}{CVDPREVENT API documentation: Area nested subsystems}
}

\examples{
\donttest{
# View the nested structure for Somerset STP (area_id = 5)
returned_list <- cvd_area_nested_subsystems(area_id = 5)
returned_list |> summary()

# See details for the first five immediate children of Somerset STP
returned_list$level_2 |> dplyr::slice_head(n = 5)

# View the nested structure for Leicester Central PCN (area_id = 701)
returned_list <- cvd_area_nested_subsystems(area_id = 701)
returned_list |> summary()

# See the GP practice children of the PCN
returned_list$level_2
}

}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
