% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_dens_obs}
\alias{calc_dens_obs}
\alias{calc_dens}
\title{Calculate and Combine Density Estimates for Observed and Predicted Data}
\usage{
calc_dens_obs(
  rts_u,
  rts_l,
  one_cond,
  t_max = NULL,
  discr = NULL,
  scaling_factor = 1
)

calc_dens(
  pdf_u = NULL,
  pdf_l = NULL,
  t_vec = NULL,
  t_max = NULL,
  discr = NULL,
  rts_u = NULL,
  rts_l = NULL,
  one_cond,
  b_coding,
  scaling_factor = 1
)
}
\arguments{
\item{rts_u, rts_l}{vectors of RTs for the upper and lower boundary}

\item{one_cond}{character label}

\item{t_max}{a single numeric value specifying the maximum RT to consider.
Defaults to the smallest multiple of \code{discr} above the maximum RT. If
\code{t_vec} is provided, \code{t_max} defaults to the maximum value of \code{t_vec}.}

\item{discr}{a single numeric value defining the bin width for histogram and
KDE estimation. Defaults to 0.015 (seconds).}

\item{scaling_factor}{a single numeric value, multiplied with the PDFs.
It is used to scale the corresponding probability mass
proportional to the number of trials per condition. Defaults to \code{1.0}.}

\item{pdf_u, pdf_l}{density values for the upper and lower boundary}

\item{t_vec}{the time space (required for the pdfs)}

\item{b_coding}{used for accessing the upper/lower boundary labels,
determines the corresponding columns of the returned data.frame
(e.g., Quant_\code{corr}).}
}
\value{
A \code{stats_dm} object (via \code{\link[=new_stats_dm]{new_stats_dm()}}) containing a
\code{data.frame} with columns:
\itemize{
\item \code{Source}: indicates whether the row is from observed (\code{"obs"}) or
predicted (\code{"pred"}) data.
\item \code{Cond}: the condition label.
\item \code{Time}: the time point corresponding to the density value.
\item \code{Stat}: type of density summary—\code{"hist"} or \code{"kde"} (for observed data),
or \code{"pdf"} (for predicted data).
\item \verb{Dens_<U>}: density value for the upper response.
\item \verb{Dens_<L>}: density value for the lower response.
}

The \verb{<U>} and \verb{<L>} placeholders are determined by the \code{b_coding} argument.
}
\description{
Internal helper functions that return a \code{data.frame} summarizing density
values for observed and predicted response times.
}
\details{
\code{calc_dens_obs()} computes empirical histograms and kernel density
estimates for a single condition based on observed RTs.

\code{calc_dens()} serves as a general interface that combines observed and
predicted data into a single \code{data.frame}. Observed data (\code{rts_u} and
\code{rts_l}) is passed to \code{calc_dens_obs()}. Predicted data (\code{pdf_u} and
\code{pdf_l}) is wrapped into a \code{data.frame} that matches the structure returned
by \code{calc_dens_obs()}. If both are provided, observed and predicted data
are row-bound into a single \code{data.frame}.

These functions are used internally to support \code{type = "density"} in
\code{\link[=calc_stats]{calc_stats()}}, providing a full distributional overview.
}
\keyword{internal}
