% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_dann.R
\name{predict.sub_dann}
\alias{predict.sub_dann}
\title{Discriminant Adaptive Nearest Neighbor With Subspace Reduction}
\usage{
\method{predict}{sub_dann}(object, new_data, type = "class", ...)
}
\arguments{
\item{object}{of class inheriting from "sub_dann"}

\item{new_data}{A data frame.}

\item{type}{Type of prediction. (class, prob)}

\item{...}{unused}
}
\value{
A data frame containing either class or class probabilities. Adheres to tidy models standards.
}
\description{
Discriminant Adaptive Nearest Neighbor With Subspace Reduction
}
\details{
An implementation of Hastie and Tibshirani's sub-dann in section 4.1 of
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest Neighbor Classification publication.}.

dann's performance suffers when noise variables are included in the model. Simulations show sub_dann
will generally be more performant in this scenario.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

test <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(test) <- c("X1", "X2", "Y")

model <- sub_dann(Y ~ X1 + X2, train)
predict(model, test, "class")

predict(model, test, "prob")
}
