% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateLogo_shinyDashboardLogoDIY.R
\name{shinyDashboardLogoDIY}
\alias{shinyDashboardLogoDIY}
\title{shinyDashboardLogoDIY}
\usage{
shinyDashboardLogoDIY(
  boldText,
  mainText,
  textSize = 15,
  badgeText,
  badgeTextColor,
  badgeTextSize = 2,
  badgeBackColor,
  badgeBorderRadius = 3
)
}
\arguments{
\item{boldText}{String. Bold text for the logo.}

\item{mainText}{String. Main text for the logo.}

\item{textSize}{Numeric. Text size for the logo. Defaults to 15.}

\item{badgeText}{String. Text for the logo badge.}

\item{badgeTextColor}{String. Text color of the logo badge.}

\item{badgeTextSize}{Numeric. Text color of the logo badge. Defaults to 2.}

\item{badgeBackColor}{String. Background color of the logo badge.}

\item{badgeBorderRadius}{Numeric. Border radius of the logo badge. Defaults to 3.}
}
\value{
HTML code. Logo for shinydashboard's sidebar.
}
\description{
Creates a custom logo object for a shinydashboard application
}
\note{
This logo design was inspired from \url{http://www.dataseries.org/}.
}
\examples{
\donttest{
customLogo <- shinyDashboardLogoDIY(
  boldText = "SD"
  ,mainText = "Themes"
  ,textSize = 16
  ,badgeText = "v1.1"
  ,badgeTextColor = "white"
  ,badgeTextSize = 2
  ,badgeBackColor = "#40E0D0"
  ,badgeBorderRadius = 3
)
}
}
\seealso{
\code{\link{shinyDashboardLogo}, \link{cssGradientThreeColors}}
}
