% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casting.R
\name{cast-decimal}
\alias{cast-decimal}
\alias{deb_as_decimal}
\alias{deb_as_decimal.default}
\alias{deb_as_decimal.deb_decimal}
\alias{deb_as_decimal.deb_lsd}
\alias{deb_as_decimal.deb_tetra}
\alias{deb_as_decimal.numeric}
\alias{deb_as_decimal.logical}
\alias{deb_as_decimal.list}
\title{Cast to \code{deb_decimal}}
\usage{
deb_as_decimal(x, ...)

\method{deb_as_decimal}{default}(x, ...)

\method{deb_as_decimal}{deb_decimal}(x, ...)

\method{deb_as_decimal}{deb_lsd}(x, unit = c("l", "s", "d"), ...)

\method{deb_as_decimal}{deb_tetra}(x, unit = c("l", "s", "d", "f"), ...)

\method{deb_as_decimal}{numeric}(x, unit = c("l", "s", "d", "f"), bases = c(20, 12), ...)

\method{deb_as_decimal}{logical}(x, unit = c("l", "s", "d", "f"), bases = c(20, 12), ...)

\method{deb_as_decimal}{list}(x, unit = c("l", "s", "d", "f"), bases = c(20, 12), ...)
}
\arguments{
\item{x}{An object to coerce to \code{deb_decimal}.}

\item{...}{Arguments passed on to further methods.}

\item{unit}{A character vector of length one indicating the unit for the
decimalized values, either \code{"l"} (libra, the default), \code{"s"} (solidus),
or \code{"d"} (denarius).}

\item{bases}{Numeric vector of length 2 used to specify the bases for the
solidus or s and denarius or d units. Default is \code{c(20, 12)}, which
conforms to the most widely used system of 1 pound = 20 shillings and
1 shilling = 12 pence.}
}
\value{
A \code{deb_decimal} vector.
}
\description{
Cast \code{x} to a \code{deb_decimal} vector.
}
\details{
Like \code{\link[=deb_as_lsd]{deb_as_lsd()}}, \code{deb_as_decimal()} provides a method to
cast a list of numeric vectors of length 3 to \code{deb_decimal}. This may be
helpful because the data is input by the value instead of by the unit.
}
\examples{

# Cast a deb_lsd vector to deb_decimal
x <- deb_lsd(l = c(5, 3, 7),
             s = c(16, 5, 6),
             d = c(6, 0, 8))
deb_as_decimal(x)

# Bases are automatically applied when
# casting from deb_lsd to deb_decimal
x2 <- deb_lsd(l = c(5, 3, 7),
              s = c(16, 5, 6),
              d = c(6, 0, 8),
              bases = c(60, 16))
deb_as_decimal(x2)

# Cast a deb_tetra vector to deb_decimal
# Bases are automatically applied, creating
# a deb_decimal vector with three bases units.
y <- deb_tetra(l = c(5, 13, 7),
               s = c(12, 8, 16),
               d = c(3, 11, 0),
               f = c(1, 3, 2))
deb_as_decimal(y)

# Cast a numeric vector to deb_decimal
z <- c(5.825, 3.25, 22/3)
deb_as_decimal(z)

# Use the unit and bases arguments to specify
# the unit and apply non-default bases
deb_as_decimal(z, unit = "s", bases = c(60, 16))

# Casting a list to deb_decimal provides an
# alternative to get lsd values to deb_decimal.
lsd_list <- list(c(5, 12, 3),
                 c(13, 8, 11),
                 c(7, 16, 0))
deb_as_decimal(lsd_list)

}
\seealso{
\code{\link[=deb_as_lsd]{deb_as_lsd()}} and \code{\link[=deb_as_tetra]{deb_as_tetra()}}
}
