% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dafforne_transactions}
\alias{dafforne_transactions}
\title{Transactions from the practice journal and ledger of Richard Dafforne}
\format{
A data frame with 177 rows and 8 variables.
}
\source{
Richard Dafforne, \emph{The Merchant's Mirrour, Or Directions for the}
\emph{Perfect Ordering and Keeping of His Accounts}, Third Edition, (London,
1660)
}
\usage{
dafforne_transactions
}
\description{
A data set of the transactions from the first practice journal and ledger in
Richard Dafforne's accounting manual from 1660 called \emph{The Merchant's}
\emph{Mirrour}. By 1660 \emph{The Merchant's Mirrour} was in its third edition, and
its contents had been printed in the well-known merchant manual of Gerard
Malynes, \emph{Consuetudo Vel Lex Mercatoira} since the 1636 edition, making it
one of the most popular bookkeeping manuals in 17th-century England. The
data set is meant to be used in conjunction with \code{dafforne_accounts}. It
contains the transactions in the practice journal and ledger that Dafforne
used to teach double-entry bookkeeping practices.
}
\details{
The data set does not include the last 16 transactions recorded in the
journal, which deal with the balancing of the book. These transactions can
be recreated using the lsd account functions in \code{debkeepr}.
}
\section{Variables}{

\itemize{
\item \code{id}: Numeric id for each transaction.
\item \code{credit}: Account id for the credit account in the transactions. The
accounts that discharges the transactional value or from which the
value derives. The account ids correspond to the \code{id} variable in
\code{dafforne_accounts}.
\item \code{debit}: Account id for the debit account in the transactions. The
accounts that receive the transactional value. The account ids
correspond to the \code{id} variable in \code{dafforne_accounts}.
\item \code{date}: Date on which the transaction was entered into the journal. Date
conforms to the Anglican calendar that used the old Julian calendar with
the new year on 25 March. Encoded as a date vector.
\item \code{lsd}: Column of class \code{deb_lsd} with pounds, shillings, and pence
values. Bases for shillings and pence are 20 and 12 respectively.
\item \code{journal}: Page on which the transaction is recorded in the journal.
\item \code{ledger}: The pages on which the transaction is recorded in the ledger.
The number before the slash is the page on which the debit is recorded.
The number after the slash is the page on which the credit is recorded.
\item \code{description}: Description of the transaction as recorded in the
journal.
}
}

\keyword{datasets}
