% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Generate simulation data for testing}
\usage{
sim_data(type = "step1D", ds = 0.001, n = 300L, sigma2y = NULL)
}
\arguments{
\item{type}{type of function. Can be 'step1D', 'Monterrubio1D', 'dampedwave1D', 'step2D', 'AWU_RBF_2D', or 'AWU_RBF_LFT_2D'}

\item{ds}{spatial grid length}

\item{n}{number of data points}

\item{sigma2y}{measurement-error variance}
}
\value{
\code{sim_data} returns a list containing the following items:
\describe{
\item{"s"}{Process locations on a fine grid with spacing \code{ds}}
\item{"sobs"}{Observation locations}
\item{"swarped"}{The warping function (when this is also simulated)}
\item{"f_true"}{The true process on the fine grid}
\item{"y"}{The simulated observation data}
 }
}
\description{
Generates simulated data for use in experiments
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
sim <- sim_data(type = "step1D", ds = 0.001)
 }
}
}
