% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osat.R
\name{osat_score}
\alias{osat_score}
\title{Compute OSAT score for sample assignment.}
\usage{
osat_score(bc, batch_vars, feature_vars, expected_dt = NULL, quiet = FALSE)
}
\arguments{
\item{bc}{\link{BatchContainer} with samples
or \code{\link[data.table:data.table]{data.table}}/\link{data.frame} where every row is a location
in a container and a sample in this location.}

\item{batch_vars}{\link{character} vector with batch variable names to take into account for the
score computation.}

\item{feature_vars}{\link{character} vector with sample variable names to take into account for
score computation.}

\item{expected_dt}{A \code{\link[data.table:data.table]{data.table}} with expected number of samples sample
variables and batch variables combination. This is not required, however it does not change
during the optimization process. So it is a good idea to cache this value.}

\item{quiet}{Do not warn about \code{NA}s in feature columns.}
}
\value{
a list with two attributes: \verb{$score} (numeric score value), \verb{$expected_dt}
(expected counts \code{data.table} for reuse)
}
\description{
The OSAT score is intended to ensure even distribution of samples across
batches and is closely related to the chi-square test contingency table
(Yan et al. (2012) \doi{10.1186/1471-2164-13-689}).
}
\examples{
sample_assignment <- tibble::tribble(
  ~ID, ~SampleType, ~Sex, ~plate,
  1, "Case", "Female", 1,
  2, "Case", "Female", 1,
  3, "Case", "Male", 2,
  4, "Control", "Female", 2,
  5, "Control", "Female", 1,
  6, "Control", "Male", 2,
  NA, NA, NA, 1,
  NA, NA, NA, 2,
)

osat_score(sample_assignment,
  batch_vars = "plate",
  feature_vars = c("SampleType", "Sex")
)
}
