% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{soya}
\alias{soya}
\title{Soya and sperm counts data}
\format{
A tibble with 80 rows and 3 variables.
}
\source{
\href{https://www.discovr.rocks/csv/soya.csv}{www.discovr.rocks/csv/soya.csv}
}
\usage{
soya
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
I read a story in a newspaper (yes, back when they existed) claiming that the chemical genistein, which is
naturally occurring in soya, was linked to lowered sperm counts in Western males. When you read the actual study,
it had been conducted on rats, it found no link to lowered sperm counts, but there was evidence of abnormal sexual
development in male rats (probably because genistein acts like oestrogen). As journalists tend to do, a study showing no
link between soya and sperm counts was used as the scientific basis for an article about soya being the cause of declining
sperm counts in Western males. Imagine the rat study was enough for us to want to test this idea in humans.
We recruit 80 males and split them into four groups that vary in the number of soya 'meals' (a dinner containing 75g of soya)
they ate per week over a year: no soya meals (i.e., none in the whole year), one per week (52 over the year),
four per week (208 over the year), and seven per week (364 over the year). At the end of the year, participants
produced some sperm that I could count (when I say 'I', I mean someone else in a laboratory as far away from me as humanly possible).
The fictitious data contain the following variables:
\itemize{
\item \strong{id}: The participant's id
\item \strong{soya}: How many soya meals per week consumed over a year (none, 1, 4 and 7)
\item \strong{sperm}: number of sperm cells per milliliter of semen in millions (yes, I did have to Google that)
}
}
\keyword{datasets}
