% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{check_divent_args}
\alias{check_divent_args}
\title{check_divent_args}
\usage{
check_divent_args(
  abd = NULL,
  abundances = NULL,
  alpha = NULL,
  as_numeric = NULL,
  bootstrap = NULL,
  check_arguments = NULL,
  correction = NULL,
  coverage_estimator = NULL,
  distances = NULL,
  distribution = NULL,
  estimator = NULL,
  fisher_alpha = NULL,
  gamma = NULL,
  global = NULL,
  jack_alpha = NULL,
  jack_max = NULL,
  k = NULL,
  level = NULL,
  n = NULL,
  n_simulations = NULL,
  normalize = NULL,
  orders = NULL,
  prob = NULL,
  prob_geom = NULL,
  probability_estimator = NULL,
  q = NULL,
  q_threshold = NULL,
  r = NULL,
  rate = NULL,
  richness_estimator = NULL,
  sample_coverage = NULL,
  sd_lnorm = NULL,
  show_progress = NULL,
  similarities = NULL,
  size = NULL,
  species_number = NULL,
  species_distribution = NULL,
  thomas_mu = NULL,
  thomas_scale = NULL,
  tree = NULL,
  use.names = NULL,
  unveiling = NULL,
  weights = NULL,
  w_max = NULL,
  w_mean = NULL,
  w_min = NULL,
  weibull_scale = NULL,
  weibull_shape = NULL,
  X = NULL,
  win = NULL
)
}
\arguments{
\item{abd}{a numeric vector containing abundances.}

\item{abundances}{an object of class \link{abundances}.}

\item{alpha}{the risk level, 5\% by default.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{bootstrap}{the method used to obtain the probabilities to generate
bootstrapped communities from observed abundances.
If "Marcon2012", the probabilities are simply the abundances divided by the total
number of individuals \insertCite{Marcon2012a}{divent}.
If "Chao2013" or "Chao2015" (by default), a more sophisticated approach is used
(see \link{as_probabilities}) following \insertCite{Chao2013;textual}{divent} or
\insertCite{Chao2015;textual}{divent}.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{correction}{the edge-effect correction to apply when estimating
the number of neighbors.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{distances}{a distance matrix or an object of class \link[stats:dist]{stats::dist}.}

\item{distribution}{The distribution of species abundances.
May be "lnorm" (log-normal), "lseries" (log-series), "geom" (geometric) or
"bstick" (broken stick).}

\item{estimator}{an estimator of asymptotic entropy, diversity or richness.}

\item{fisher_alpha}{Fisher's \eqn{\alpha} in the log-series distribution.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}

\item{global}{if \code{TRUE}, a global envelope sensu \insertCite{Duranton2005}{divent} is calculated.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{k}{the order of Hurlbert's diversity.}

\item{level}{the level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{n}{the number of observations.}

\item{n_simulations}{the number of simulations used to estimate the confidence envelope.}

\item{normalize}{if \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{orders}{The orders of diversity.}

\item{prob}{a numeric vector containing probabilities.}

\item{prob_geom}{the proportion of resources taken by successive species
of the geometric distribution.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{q}{a number: the order of diversity.}

\item{q_threshold}{the value of \code{q} above which diversity is computed
directly with the naive estimator \eqn{(\sum{p_s^q}^{\frac{1}{(1-q)}}},
without computing entropy.
When \code{q} is great, the exponential of entropy goes to \eqn{0^{\frac{1}{(1-q)}}},
causing rounding errors while the naive estimator of diversity is less and
less biased.}

\item{r}{a vector of distances.}

\item{rate}{the decay rate of the exponential similarity.}

\item{richness_estimator}{an estimator of richness to evaluate the total number of species,
see \link{div_richness}. used for interpolation and extrapolation.}

\item{sample_coverage}{the sample coverage of \code{x} calculated elsewhere.
Used to calculate the gamma diversity of meta-communities, see details.}

\item{sd_lnorm}{the simulated log-normal distribution standard deviation.
This is the standard deviation on the log scale.}

\item{show_progress}{if TRUE, a progress bar is shown during long computations.}

\item{similarities}{a similarity matrix, that can be obtained by \link{fun_similarity}.
Its default value is the identity matrix.}

\item{size}{the number of individuals to draw in each community.}

\item{species_number}{the number of species.}

\item{species_distribution}{an object of class \link{species_distribution}.}

\item{thomas_mu}{in Thomas point patterns, the mean number of points per cluster.
The intensity of the Poisson process of cluster centers is calculated as
the number of points (\code{size}) per area divided by \code{thomas_mu}.}

\item{thomas_scale}{in Thomas point patterns, the standard deviation of random displacement
(along each coordinate axis) of a point from its cluster center.}

\item{tree}{an ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{use.names}{if \code{TRUE}, the names of the \code{species_distribution} are kept
in the matrix or vector they are converted to.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{weights}{the weights of the sites of the species distributions.}

\item{w_max}{the maximum weight in a uniform distribution.}

\item{w_mean}{the mean weight in an exponential distribution
(i.e. the negative of the inverse of the decay rate).}

\item{w_min}{the minimum weight in a uniform, exponential or Weibull distribution.}

\item{weibull_scale}{the scale parameter in a Weibull distribution.}

\item{weibull_shape}{the shape parameter in a Weibull distribution.}

\item{X}{a spatialized community
(A \link[dbmss:wmppp]{dbmss::wmppp} object with \code{PointType} values as species names.)}

\item{win}{the window containing the point pattern.
It is an \link[spatstat.geom:owin]{spatstat.geom::owin} object.
Default is a 1x1 square.}
}
\value{
Returns \code{TRUE} or stops if a problem is detected.
}
\description{
Checks the arguments of a function of the package divent
}
\details{
The function compares the arguments passed to its parent function to the type
they should be and performs some extra tests, \emph{e.g.} probabilities must be positive and sum to 1.
It stops if an argument is not correct.

The function is always called without arguments.
Its arguments exist only for documentation.
}
\keyword{internal}
