\name{double.truncation-package}
\alias{double.truncation-package}
\alias{double.truncation}
\docType{package}
\title{
Analysis of Doubly-Truncated Data
}
\description{
Likelihood-based inference methods with doubly-truncated data are developed under various models.
 Nonparametric models are based on Efron and Petrosian (1999) <doi:10.1080/01621459.1999.10474187> and
 Emura, Konno, and Michimae (2015) <doi:10.1007/s10985-014-9297-5>.
 Parametric models from the special exponential family (SEF) are based on
 Hu and Emura (2015) <doi:10.1007/s00180-015-0564-z> and
 Emura, Hu and Konno (2017) <doi:10.1007/s00362-015-0730-y>.
 The parametric location-scale models are based on Dorre et al. (2021) <doi:10.1007/s00180-020-01027-6>.
}
\details{
Details are seen from the references.
}
\author{
Takeshi Emura, Ya-Hsuan Hu, Chung-Yan Huang
Maintainer: Takeshi Emura <takeshiemura@gmail.com>
}
\references{
Dorre A, Emura T (2019) Analysis of Doubly Truncated Data, An Introduction,
 JSS Research Series in Statistics, Springer

Dorre A, Huang CY, Tseng YK, Emura T (2021) Likelihood-based analysis of
 doubly-truncated data under the location-scale and AFT model, Computation Stat 36(1): 375-408 

Efron B, Petrosian V (1999). Nonparametric methods for doubly truncated data. 
J Am Stat Assoc 94: 824-834

Emura T, Konno Y, Michimae H (2015). Statistical inference based on the 
nonparametric maximum likelihood estimator under double-truncation. 
Lifetime Data Analysis 21: 397-418

Emura T, Hu YH, Konno Y (2017) Asymptotic inference for maximum likelihood estimators
 under the special exponential family with double-truncation, Stat Pap 58 (3): 877-909

Hu YH, Emura T (2015) Maximum likelihood estimation for a special exponential family
 under random double-truncation, Computation Stat 30 (4): 1199-229
}
\keyword{ package }