% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rem_exp_weights.R
\name{remExpWeights}
\alias{remExpWeights}
\title{Helper Function to Compute Minimum Effective Time and Exponential Weights for REM Statistics}
\usage{
remExpWeights(
  current,
  past = NULL,
  halflife,
  dyadic_weight,
  Lerneretal_2013 = FALSE,
  exp.weights = TRUE
)
}
\arguments{
\item{current}{The current relational event time.}

\item{past}{The numeric vector of past event times (for exponential weighting only).}

\item{halflife}{The halflife parameter for exponential weighting.}

\item{dyadic_weight}{The dyadic (event) weight cutoff for relational relevancy.}

\item{Lerneretal_2013}{TRUE/FALSE. If TRUE, the function uses the Lerner et al. (2013) exponential weighting function. If FALSE, the function uses the Lerner and Lomi (2020) exponential weighting function.}

\item{exp.weights}{TRUE/FALSE. If TRUE, the function computes the exponential weights for past relational events. If FALSE, the function computes the minimum effective time for a relational event (that is, the minimum past time that would result in a 0 value for an exponential weight).}
}
\value{
When exp.weights = TRUE, the numeric vector of exponential decay weights. When exp.weights = FALSE, the scalar for the minimum event cut-off time.
}
\description{
A helper function for computing exponential decay weights and the corresponding minimum effective time used
to calculate network statistics in relational event models within the \pkg{dream} package.
This implementation follows the formulations of Lerner et al. (2013) and Lerner & Lomi (2020).
Although primarily designed for internal use (e.g., within \code{\link{computeReciprocity}}),
it may also be of interest to users working directly with REM statistics (e.g., creating new statistics).
}
\details{
\itemize{
\item \strong{Exponential Weighting Function}:
\itemize{
\item Lerner & Lomi (2020): \eqn{w(u,a,t) = \sum \exp(- (t - t') * (\log(2)/T_{1/2}))}
\item Lerner et al. (2013): \eqn{w(u,a,t) = \sum \exp(- (t - t') * (\log(2)/T_{1/2})) * (\log(2)/T_{1/2})}
}
\item \strong{Minimum Effective Time (MEF)}:
\itemize{
\item Lerner & Lomi (2020): \eqn{MEF = t + \log(w) / (\log(2)/T_{1/2})}
\item Lerner et al. (2013): \eqn{MEF = t + [T_{1/2} * \log((w * T_{1/2}) / \log(2))] / \log(2)}
}
}
}
\references{
Lerner, Jürgen and Alessandro Lomi. 2020. “Reliability of relational event
model estimates under sampling: How to fit a relational event model to 360
million dyadic events.” \emph{Network Science} 8(1): 97-135.

Lerner, Jürgen, Margit Bussman, Tom A.B. Snijders, and Ulrik Brandes. 2013. "
Modeling Frequency and Type of Interaction in Event Networks."
\emph{The Corvinus Journal of Sociology and Social Policy} 4(1): 3-32.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
