% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_drift_checks.R
\name{print.all_drifter_checks}
\alias{print.all_drifter_checks}
\title{Print All Drifter Checks}
\usage{
\method{print}{all_drifter_checks}(x, ...)
}
\arguments{
\item{x}{an object of the class `all_drifter_checks`}

\item{...}{other arguments, currently ignored}
}
\value{
this function prints all drifter checks
}
\description{
Print All Drifter Checks
}
\examples{
 library("DALEX")
 model_old <- lm(m2.price ~ ., data = apartments)
 model_new <- lm(m2.price ~ ., data = apartments_test[1:1000,])
 check_drift(model_old, model_new,
                  apartments, apartments_test,
                  apartments$m2.price, apartments_test$m2.price)
 \donttest{
 library("ranger")
 predict_function <- function(m,x,...) predict(m, x, ...)$predictions
 model_old <- ranger(m2.price ~ ., data = apartments)
 model_new <- ranger(m2.price ~ ., data = apartments_test)
 check_drift(model_old, model_new,
                  apartments, apartments_test,
                  apartments$m2.price, apartments_test$m2.price,
                  predict_function = predict_function)
}
}
