% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{get_set}
\alias{get_set}
\title{Get a set of x-y coordinates (from Anscombe's Quartet)}
\source{
See \code{?datasets:anscombe} for details and references.
}
\usage{
get_set(n = 1)
}
\arguments{
\item{n}{Number of set (as an integer from 1 to 4)).
Default: \code{n = 1}.}
}
\description{
\code{get_set} obtains a set of x/y coordinates and returns it 
(as a data frame).
}
\details{
Each set stems from Anscombe's Quartet 
(see \code{datasets::anscombe}, hence 
\code{1 <= n <= 4}) and is returned as an 
\code{11 x 2} data frame.
}
\examples{
get_set(1)
plot(get_set(2), col = "red")

}
\seealso{
Other data functions: 
\code{\link{make_grid}()}
}
\concept{data functions}
