% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_fun.R
\name{theme_clean}
\alias{theme_clean}
\title{A clean alternative theme for \strong{ggplot2}}
\usage{
theme_clean(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22,
  col_title = grey(0, 1),
  col_panel = grey(0.85, 1),
  col_gridx = grey(1, 1),
  col_gridy = grey(1, 1),
  col_ticks = grey(0.1, 1)
)
}
\arguments{
\item{base_size}{Base font size (optional, numeric). 
Default: \code{base_size = 11}.}

\item{base_family}{Base font family (optional, character). 
Default: \code{base_family = ""}. 
Options include \code{"mono"}, \code{"sans"} (default), and "serif".}

\item{base_line_size}{Base line size (optional, numeric). 
Default: \code{base_line_size = base_size/22}.}

\item{base_rect_size}{Base rectangle size (optional, numeric). 
Default: \code{base_rect_size = base_size/22}.}

\item{col_title}{Color of plot title (and tag). 
Default: \code{col_title = grey(.0, 1)} (i.e., "black").}

\item{col_panel}{Color of panel background(s). 
Default: \code{col_panel = grey(.85, 1)} (i.e., light "grey").}

\item{col_gridx}{Color of (major) panel lines (through x/vertical). 
Default: \code{col_gridx = grey(1.0, 1)} (i.e., "white").}

\item{col_gridy}{Color of (major) panel lines (through y/horizontal). 
Default: \code{col_gridy = grey(1.0, 1)} (i.e., "white").}

\item{col_ticks}{Color of axes text and ticks. 
Default: \code{col_ticks = grey(.10, 1)} (i.e., near "black").}
}
\value{
A \strong{ggplot2} theme.
}
\description{
\code{theme_clean} provides an alternative \strong{ds4psy} theme 
to use in \strong{ggplot2} commands.
}
\details{
\code{theme_clean} is more minimal than \code{\link{theme_ds4psy}} 
and fills panel backgrounds with a color \code{col_panel}. 

This theme works well for plots with multiple panels, 
strong colors and bright color accents, 
but is of limited use with transparent colors.
}
\examples{

\donttest{
# Plotting iris dataset (using ggplot2, theme_grau, and unikn colors):
  
library('ggplot2')  # theme_clean() requires ggplot2
library('unikn')    # for colors and usecol() function
   
ggplot(datasets::iris) +
  geom_jitter(aes(x = Sepal.Length, y = Sepal.Width, color = Species), size = 3, alpha = 3/4) +
  facet_wrap(~Species) +
  scale_color_manual(values = usecol(pal = c(Pinky, Karpfenblau, Seegruen))) +
  labs(tag = "B",
       title = "Iris sepals",
       caption = "Data from datasets::iris") + 
  coord_fixed(ratio = 3/2) + 
  theme_clean()

}

}
\seealso{
\code{\link{theme_ds4psy}} for default theme.

Other plot functions: 
\code{\link{plot_charmap}()},
\code{\link{plot_chars}()},
\code{\link{plot_circ_points}()},
\code{\link{plot_fn}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
