% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{daily_data}
\alias{daily_data}
\title{Exemplary time series}
\format{
An xts data set containing 3 time series:
\describe{
\item{currency_circulation}{Currency in circulation in Germany, in billion Euros, sum of small denominations: i.e. 5 Euro + 10 Euro + 20 Euro + 50 Euro. Series compiled by Deutsche Bundesbank}
\item{elec_consumption}{Electricity consumption in Germany in GWh. Compiled by Bundesnetzagentur (German Federal Network Agency)}
\item{no2}{Nitrogen dioxide (NO2) immissions averaged over all available measuring stations in Europe that are made available by the European Environment Agency (EEA)}
#' \item{currency_circulation_sa}{Seasonally and calendar adjusted version using dsa of currency_circulation}
\item{elec_consumption_sa}{Seasonally and calendar adjusted version using dsa of elec_consumption}
\item{no2_sa}{Seasonally and calendar adjusted version using dsa of no2}
}
}
\source{
Own calculations, Deutsche Bundesbank, Bundesnetzagentur, EEA
}
\usage{
daily_data
}
\description{
Three time series that have been analysed by Ollech (2021) and their seasonally and calendar adjusted variants.
}
\references{
Ollech, Daniel (2021). Seasonal Adjustment of Daily Time Series. Journal of Time Series Econometrics (forthcoming).
}
\author{
Daniel Ollech
}
\keyword{datasets}
