% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cphGM.R
\name{cphGM}
\alias{cphGM}
\title{CoxPH model with parametric baseline and frailty terms}
\usage{
cphGM(
  formula,
  fterm,
  Time,
  status,
  id,
  data,
  bhdist,
  method = "L-BFGS-B",
  maxit = 200
)
}
\arguments{
\item{formula}{survival model formula like Surv(time,status)~x1+x2}

\item{fterm}{frailty term like c('gamma','center'). Currently we have the option for gamma distribution.}

\item{Time}{survival time column}

\item{status}{survival status column}

\item{id}{id column}

\item{data}{dataset}

\item{bhdist}{distribution of survival time at baseline. Available option 'weibull','exponential','gompertz',}

\item{method}{options are 'LFGS','L-BFGS-G','CG' etc. for more details see \link{optim}}

\item{maxit}{maximum number of iteration}
}
\value{
Estimates obtained from coxph model with the frailty terms.
}
\description{
Function for estimating the parameters of coxPH model with frailty terms
}
\details{
The hazard model is as follows:
 \deqn{h_i(t)=z_ih_0(t)exp(\textbf{x}_i\beta)\;;i=1,2,3,...,n}
where baseline survival distribution could be Weibull distribution and the hazard function is:
\deqn{h_0(t)=\rho \lambda t^{\rho-1}}. Similarly we can have Expoenetial, log logistic distribution. The following are the formula for hazard and cummulative hazard function
For exponential: \eqn{h_0(t)=\lambda} and \eqn{H_0(t)=\lambda t}\;\eqn{\lambda>0}
    Gompertz: \eqn{h_0(t)=\lambda exp(\gamma t)} and \eqn{H_0(t)=\frac{\lambda}{\gamma}(exp(\gamma t)-1)};\eqn{\lambda,\gamma>0}
The frailty term \eqn{z_i} follows Gamma distribution with parameter \eqn{\theta}. The parameter estimates are obtained by maximising the log likelihood
\deqn{\prod_{i=1}^{n}l_i(\beta,\theta,\lambda,\rho)}
The method argument allows the user to select suitable optimisation method available in \code{optim} function.
}
\examples{
\donttest{
##
X1<-matrix(rnorm(1000*2),1000,2)
simulated_data<-simfdata(n=1000,beta=c(0.5,0.5),fvar=0.5,
X=X1)
model1<-cphGM(formula=Surv(time,status)~X1+X2,
fterm<-c('gamma','id'),Time="time",status="status",
id="id",data=simulated_data,bhdist='weibull')
model1
##
}
}
\references{
Vishwakarma, G. K., Bhattacherjee, A., Rajbongshi, B. K., & Tripathy, A. (2024). Censored imputation of time to event outcome through survival proximity score method. \emph{Journal of Computational and Applied Mathematics}, 116103;

Bhattacharjee, A., Vishwakarma, G. K., Tripathy, A., & Rajbongshi, B. K. (2024). Competing risk multistate censored data modeling by propensity score matching method. \emph{Scientific Reports}, 14(1), 4368.
}
\seealso{
\link{dscore},\link{simfdata}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra K. Vishwakarma
}
