% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleEvolParams}
\alias{sampleEvolParams}
\title{Sampler evolution error variance parameters}
\usage{
sampleEvolParams(
  omega,
  evolParams,
  sigma_e = 1,
  evol_error = "DHS",
  loc = NULL
)
}
\arguments{
\item{omega}{\code{T x p} matrix of evolution errors}

\item{evolParams}{list of parameters pertaining to each \code{evol_error} type to be updated}

\item{sigma_e}{the observation error standard deviation; for (optional) scaling purposes}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), or 'NIG' (normal-inverse-gamma prior)}

\item{loc}{list of the row and column indices to fill in a band-sparse matrix}
}
\value{
List of relevant components in \code{evolParams}: \code{sigma_wt}, the \code{T x p} matrix of evolution standard deviations,
and additional parameters associated with the DHS and HS priors.
}
\description{
Compute one draw of evolution error variance parameters under the various options:
\itemize{
\item dynamic horseshoe prior ('DHS');
\item horseshoe prior ('HS');
\item normal-inverse-gamma prior ('NIG').
}
}
\note{
The list \code{evolParams} is specific to each \code{evol_error} type,
but in each case contains the evolution error standard deviations \code{sigma_wt}.

To avoid scaling by the observation standard deviation \code{sigma_e},
simply use \code{sigma_e = 1} in the functional call.
}
