% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{simRegression0}
\alias{simRegression0}
\title{Simulate noisy observations from a dynamic regression model}
\usage{
simRegression0(
  signalNames = c("bumps", "blocks"),
  nT = 200,
  RSNR = 10,
  p_0 = 5,
  include_intercept = TRUE,
  scale_all = TRUE,
  include_plot = TRUE,
  ar1 = 0
)
}
\arguments{
\item{signalNames}{vector of strings matching the "name" argument in the \code{simUnivariate()} function,
e.g. "bumps" or "doppler"}

\item{nT}{number of points}

\item{RSNR}{root-signal-to-noise ratio}

\item{p_0}{number of true zero regression terms to include}

\item{include_intercept}{logical; if TRUE, the first column of X is 1's}

\item{scale_all}{logical; if TRUE, scale all regression coefficients to [0,1]}

\item{include_plot}{logical; if TRUE, include a plot of the simulated data and the true curve}

\item{ar1}{the AR(1) coefficient for the predictors X; default is zero for iid N(0,1) predictors}
}
\value{
a list containing
\itemize{
\item the simulated function \code{y}
\item the simulated predictors \code{X}
\item the simulated dynamic regression coefficients \code{beta_true}
\item the true function \code{mu_true}
\item the true observation standard deviation \code{sigma_true}
}
}
\description{
Simulates data from a time series regression with dynamic regression coefficients.
The dynamic regression coefficients are selected using the options from the
\code{simUnivariate()} function in the \code{wmtsa} package.
}
\note{
The number of predictors is \code{p = length(signalNames) + p_0}.

The root-signal-to-noise ratio is defined as RSNR = (sd of true function)/(sd of noise).
}
