% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-call.R
\name{rename.dtplyr_step}
\alias{rename.dtplyr_step}
\alias{rename_with.dtplyr_step}
\title{Rename columns using their names}
\usage{
\method{rename}{dtplyr_step}(.data, ...)

\method{rename_with}{dtplyr_step}(.data, .fn, .cols = everything(), ...)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}}

\item{...}{For \code{rename()}: <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Use
\code{new_name = old_name} to rename selected variables.

For \code{rename_with()}: additional arguments passed onto \code{.fn}.}

\item{.fn}{A function used to transform the selected \code{.cols}. Should
return a character vector the same length as the input.}

\item{.cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to rename;
defaults to all columns.}
}
\description{
These are methods for the dplyr generics \code{\link[dplyr:rename]{dplyr::rename()}} and \code{\link[dplyr:rename]{dplyr::rename_with()}}.
They are both translated to \code{\link[data.table:setattr]{data.table::setnames()}}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
dt <- lazy_dt(data.frame(x = 1, y = 2, z = 3))
dt \%>\% rename(new_x = x, new_y = y)
dt \%>\% rename_with(toupper)
}
