% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_remove_keypoints.R
\name{op_remove_keypoints}
\alias{op_remove_keypoints}
\title{Remove Keypoints Based on Various Criteria}
\usage{
op_remove_keypoints(
  df,
  remove_specific_keypoints = NULL,
  remove_undetected_keypoints = FALSE,
  remove_keypoints_total_confidence = NULL,
  remove_keypoints_missing_data = NULL,
  apply_removal_equally = TRUE
)
}
\arguments{
\item{df}{A data frame containing the data to process. Keypoint columns are expected to include
x, y, and c (confidence) columns with corresponding indices.}

\item{remove_specific_keypoints}{Character vector. Specifies the keypoint indices (e.g., "1") to remove.
This will automatically remove corresponding \code{x}, \code{y}, and \code{c} columns for those indices. Default is NULL.}

\item{remove_undetected_keypoints}{Logical. If TRUE, removes keypoints where all confidence values are zero across all rows. Default is FALSE.}

\item{remove_keypoints_total_confidence}{Numeric or FALSE. A threshold for the mean confidence values.
Keypoints with a mean confidence below this threshold will be removed. If set to FALSE, behaves as NULL. Default is NULL.}

\item{remove_keypoints_missing_data}{Numeric or FALSE. A threshold (between 0 and 1) for the percentage
of missing or zero values. Columns exceeding this threshold will be removed. If set to FALSE, behaves as NULL. Default is NULL.}

\item{apply_removal_equally}{Logical. If TRUE, the same columns will be removed across all rows of the dataset.
If FALSE, removal criteria are applied separately for each combination of \code{person} and \code{region}. Default is TRUE.}
}
\value{
A data frame with specified keypoints and corresponding columns removed.
}
\description{
This function removes keypoints and their corresponding columns based on several criteria:
user-specified keypoints, low total confidence values over time, exceeding a threshold of
missing/zero values, or if all data for a keypoint is missing (i.e., all zeros).
}
\examples{
# Load example data from the package
data_path <- system.file("extdata/csv_data/dyad_1/A_body.csv", package = "duet")
df <- read.csv(data_path)

# Remove keypoints based on various criteria
result <- op_remove_keypoints(
  df = df,
  remove_specific_keypoints = c("1", "2"), # Remove specific keypoints (e.g., keypoints 1 and 2)
  remove_undetected_keypoints = TRUE,      # Remove keypoints with all zero confidence
  remove_keypoints_total_confidence = 0.5, # Remove keypoints with mean confidence below 0.5
  remove_keypoints_missing_data = 0.2,     # Remove keypoints with >20\% missing data
  apply_removal_equally = TRUE             # Apply removal equally across the dataset
)

# Display the result
print(result)
}
