test_that("scriptISAT produces correct output 1 lv", {

  dvn <- scrapeVarCross(dat = commitmentQ,
                        x_order = "spi", x_stem = "sat.g", x_delim1 = ".", x_delim2="_",
                        distinguish_1="1", distinguish_2="2")


  expect_equal(scriptISAT(dvn, lvxname = "Sat", lvyname = "Com"),
               "#Constrained Means\nsat.g.1_1 ~ tx1*1\nsat.g.1_2 ~ tx2*1\nsat.g.1_3 ~ tx3*1\nsat.g.1_4 ~ tx4*1\nsat.g.1_5 ~ tx5*1\nsat.g.2_1 ~ tx1*1\nsat.g.2_2 ~ tx2*1\nsat.g.2_3 ~ tx3*1\nsat.g.2_4 ~ tx4*1\nsat.g.2_5 ~ tx5*1\n\n#Constrained Variances\nsat.g.1_1 ~~ thx1*sat.g.1_1\nsat.g.1_2 ~~ thx2*sat.g.1_2\nsat.g.1_3 ~~ thx3*sat.g.1_3\nsat.g.1_4 ~~ thx4*sat.g.1_4\nsat.g.1_5 ~~ thx5*sat.g.1_5\nsat.g.2_1 ~~ thx1*sat.g.2_1\nsat.g.2_2 ~~ thx2*sat.g.2_2\nsat.g.2_3 ~~ thx3*sat.g.2_3\nsat.g.2_4 ~~ thx4*sat.g.2_4\nsat.g.2_5 ~~ thx5*sat.g.2_5\n\n#Constrained Intrapersonal Covariances\nsat.g.1_1 ~~ itax11*sat.g.1_2+itax12*sat.g.1_3+itax13*sat.g.1_4+itax14*sat.g.1_5\nsat.g.1_2 ~~ itax21*sat.g.1_3+itax22*sat.g.1_4+itax23*sat.g.1_5\nsat.g.1_3 ~~ itax31*sat.g.1_4+itax32*sat.g.1_5\nsat.g.1_4 ~~ itax41*sat.g.1_5\n\n\nsat.g.2_1 ~~ itax11*sat.g.2_2+itax12*sat.g.2_3+itax13*sat.g.2_4+itax14*sat.g.2_5\nsat.g.2_2 ~~ itax21*sat.g.2_3+itax22*sat.g.2_4+itax23*sat.g.2_5\nsat.g.2_3 ~~ itax31*sat.g.2_4+itax32*sat.g.2_5\nsat.g.2_4 ~~ itax41*sat.g.2_5\n\n#Constrained Interpersonal Covariancesn\nsat.g.1_1 ~~ itrx11*sat.g.2_2+itrx12*sat.g.2_3+itrx13*sat.g.2_4+itrx14*sat.g.2_5\nsat.g.1_2 ~~ itrx21*sat.g.2_3+itrx22*sat.g.2_4+itrx23*sat.g.2_5\nsat.g.1_3 ~~ itrx31*sat.g.2_4+itrx32*sat.g.2_5\nsat.g.1_4 ~~ itrx41*sat.g.2_5\n\nsat.g.2_1 ~~ itrx11*sat.g.1_2+itrx12*sat.g.1_3+itrx13*sat.g.1_4+itrx14*sat.g.1_5\nsat.g.2_2 ~~ itrx21*sat.g.1_3+itrx22*sat.g.1_4+itrx23*sat.g.1_5\nsat.g.2_3 ~~ itrx31*sat.g.1_4+itrx32*sat.g.1_5\nsat.g.2_4 ~~ itrx41*sat.g.1_5\n\n#Estimate Same-Indicator Covariances\nsat.g.1_1 ~~ NA*sat.g.2_1\nsat.g.1_2 ~~ NA*sat.g.2_2\nsat.g.1_3 ~~ NA*sat.g.2_3\nsat.g.1_4 ~~ NA*sat.g.2_4\nsat.g.1_5 ~~ NA*sat.g.2_5"
               )
})

test_that("scriptISAT produces correct output 2 lv", {

  dvn <- scrapeVarCross(dat = commitmentQ,
                        x_order = "spi", x_stem = "sat.g", x_delim1 = ".", x_delim2="_",
                        y_order="spi", y_stem="com", y_delim1 = ".", y_delim2="_",
                        distinguish_1="1", distinguish_2="2")


  expect_equal(scriptISAT(dvn, lvxname = "Sat", lvyname = "Com"),
               "#Constrained Means\nsat.g.1_1 ~ tx1*1\nsat.g.1_2 ~ tx2*1\nsat.g.1_3 ~ tx3*1\nsat.g.1_4 ~ tx4*1\nsat.g.1_5 ~ tx5*1\nsat.g.2_1 ~ tx1*1\nsat.g.2_2 ~ tx2*1\nsat.g.2_3 ~ tx3*1\nsat.g.2_4 ~ tx4*1\nsat.g.2_5 ~ tx5*1\n\ncom.1_1 ~ ty1*1\ncom.1_2 ~ ty2*1\ncom.1_3 ~ ty3*1\ncom.1_4 ~ ty4*1\ncom.1_5 ~ ty5*1\ncom.2_1 ~ ty1*1\ncom.2_2 ~ ty2*1\ncom.2_3 ~ ty3*1\ncom.2_4 ~ ty4*1\ncom.2_5 ~ ty5*1\n\n#Constrained Variances\nsat.g.1_1 ~~ thx1*sat.g.1_1\nsat.g.1_2 ~~ thx2*sat.g.1_2\nsat.g.1_3 ~~ thx3*sat.g.1_3\nsat.g.1_4 ~~ thx4*sat.g.1_4\nsat.g.1_5 ~~ thx5*sat.g.1_5\nsat.g.2_1 ~~ thx1*sat.g.2_1\nsat.g.2_2 ~~ thx2*sat.g.2_2\nsat.g.2_3 ~~ thx3*sat.g.2_3\nsat.g.2_4 ~~ thx4*sat.g.2_4\nsat.g.2_5 ~~ thx5*sat.g.2_5\n\ncom.1_1 ~~ thy1*com.1_1\ncom.1_2 ~~ thy2*com.1_2\ncom.1_3 ~~ thy3*com.1_3\ncom.1_4 ~~ thy4*com.1_4\ncom.1_5 ~~ thy5*com.1_5\ncom.2_1 ~~ thy1*com.2_1\ncom.2_2 ~~ thy2*com.2_2\ncom.2_3 ~~ thy3*com.2_3\ncom.2_4 ~~ thy4*com.2_4\ncom.2_5 ~~ thy5*com.2_5\n\n#Constrained Intrapersonal Covariances\nsat.g.1_1 ~~ itax11*sat.g.1_2+itax12*sat.g.1_3+itax13*sat.g.1_4+itax14*sat.g.1_5\nsat.g.1_2 ~~ itax21*sat.g.1_3+itax22*sat.g.1_4+itax23*sat.g.1_5\nsat.g.1_3 ~~ itax31*sat.g.1_4+itax32*sat.g.1_5\nsat.g.1_4 ~~ itax41*sat.g.1_5\n\n\nsat.g.2_1 ~~ itax11*sat.g.2_2+itax12*sat.g.2_3+itax13*sat.g.2_4+itax14*sat.g.2_5\nsat.g.2_2 ~~ itax21*sat.g.2_3+itax22*sat.g.2_4+itax23*sat.g.2_5\nsat.g.2_3 ~~ itax31*sat.g.2_4+itax32*sat.g.2_5\nsat.g.2_4 ~~ itax41*sat.g.2_5\n\ncom.1_1 ~~ itay11*com.1_2+itay12*com.1_3+itay13*com.1_4+itay14*com.1_5\ncom.1_2 ~~ itay21*com.1_3+itay22*com.1_4+itay23*com.1_5\ncom.1_3 ~~ itay31*com.1_4+itay32*com.1_5\ncom.1_4 ~~ itay41*com.1_5\n\n\ncom.2_1 ~~ itay11*com.2_2+itay12*com.2_3+itay13*com.2_4+itay14*com.2_5\ncom.2_2 ~~ itay21*com.2_3+itay22*com.2_4+itay23*com.2_5\ncom.2_3 ~~ itay31*com.2_4+itay32*com.2_5\ncom.2_4 ~~ itay41*com.2_5\n\n#Constrained Interpersonal Covariancesn\nsat.g.1_1 ~~ itrx11*sat.g.2_2+itrx12*sat.g.2_3+itrx13*sat.g.2_4+itrx14*sat.g.2_5\nsat.g.1_2 ~~ itrx21*sat.g.2_3+itrx22*sat.g.2_4+itrx23*sat.g.2_5\nsat.g.1_3 ~~ itrx31*sat.g.2_4+itrx32*sat.g.2_5\nsat.g.1_4 ~~ itrx41*sat.g.2_5\n\nsat.g.2_1 ~~ itrx11*sat.g.1_2+itrx12*sat.g.1_3+itrx13*sat.g.1_4+itrx14*sat.g.1_5\nsat.g.2_2 ~~ itrx21*sat.g.1_3+itrx22*sat.g.1_4+itrx23*sat.g.1_5\nsat.g.2_3 ~~ itrx31*sat.g.1_4+itrx32*sat.g.1_5\nsat.g.2_4 ~~ itrx41*sat.g.1_5\n\ncom.1_1 ~~ itry11*com.2_2+itry12*com.2_3+itry13*com.2_4+itry14*com.2_5\ncom.1_2 ~~ itry21*com.2_3+itry22*com.2_4+itry23*com.2_5\ncom.1_3 ~~ itry31*com.2_4+itry32*com.2_5\ncom.1_4 ~~ itry41*com.2_5\n\ncom.2_1 ~~ itry11*com.1_2+itry12*com.1_3+itry13*com.1_4+itry14*com.1_5\ncom.2_2 ~~ itry21*com.1_3+itry22*com.1_4+itry23*com.1_5\ncom.2_3 ~~ itry31*com.1_4+itry32*com.1_5\ncom.2_4 ~~ itry41*com.1_5\n\n#Estimate Same-Indicator Covariances\nsat.g.1_1 ~~ NA*sat.g.2_1\nsat.g.1_2 ~~ NA*sat.g.2_2\nsat.g.1_3 ~~ NA*sat.g.2_3\nsat.g.1_4 ~~ NA*sat.g.2_4\nsat.g.1_5 ~~ NA*sat.g.2_5\n\ncom.1_1 ~~ NA*com.2_1\ncom.1_2 ~~ NA*com.2_2\ncom.1_3 ~~ NA*com.2_3\ncom.1_4 ~~ NA*com.2_4\ncom.1_5 ~~ NA*com.2_5"
               )
})
