% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{interact.all}
\alias{interact.all}
\title{Compute all pairwise interactions between the columns of a data matrix}
\usage{
interact.all(input)
}
\arguments{
\item{input}{A data matrix (of class matrix or data.frame) for which all column-wise multiplications are to be computed}
}
\value{
A matrix where columns of the original data matrix have been multiplied, indicating column names coupled with a colon in-between
}
\description{
The function multiplies the columns (variables) of a matrix or a data.frame with each other, and produces a new matrix where all pairwise interactions are present. This also includes multiplying a column with its self, thus effectively returning a squared column.
}
\examples{
set.seed(1)
somedata <- data.frame(a = rnorm(10), b = rnorm(10), c = runif(10), d = runif(10))
somedata
allinteract <- interact.all(somedata)
allinteract
}
